<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;

/**
 * @property integer $id
 * @property integer $item_id
 * @property integer $space_id
 * @property float $price
 * @property float $off_by_percentage
 * @property float $off_by_number
 * @property integer $quantity
 * @property float $price_after_sale
 * @property boolean $is_active
 * @property string $created_at
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_at
 * @property boolean $is_deleted
 * @property string $deleted_at
 * @property integer $deleted_by
 * @property Item $item
 * @property Space $space
 * @property LineItem[] $lineItems
 */
class Stock extends Model
{
    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'integer';

    /**
     * @var array
     */
    protected $fillable = ['item_id', 'space_id', 'price', 'off_by_percentage', 'off_by_number', 'quantity', 'price_after_sale', 'is_active', 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];
    protected $hidden = ['created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];

    /**
     * Scope Active
     */
    public function scopeActive($query) {
        return $query->where('stocks.is_active', '1');
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function item()
    {
        return $this->belongsTo('App\Models\api\v1\Item');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function space()
    {
        return $this->belongsTo('App\Models\api\v1\Space');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function lineItems()
    {
        return $this->hasMany('App\Models\api\v1\LineItem');
    }
}
