<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class UsersRolesSpace extends Model
{
    use HasFactory;
    protected $guarded = ['id', 'created_at', 'updated_at'];


    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->uuid        = Str::uuid();
            $model->created_by  = auth()->user()->id ??  null;
            $model->is_active   = 1;
            $model->created_at  = now();
        });

    }
}
