<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('mfa_codes', function (Blueprint $table)
        {
            $table->id();
            $table->string('code',5);
            $table->string('recepient');
            $table->string('action');
            $table->boolean('used')->default(false);
            $table->integer('InvalidAttempts')->default(0);
            $table->timestamp('used_at')->nullable();
            $table->string('status')->nullable();
            $table->string('callback')->nullable();
            $table->timestamp('expire_at')->nullable();
            $table->unsignedBigInteger('api_key_id')->nullable();
            $table->foreign('api_key_id')->references('id')->on('api_keys')->onUpdate('cascade')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mfa_codes');
    }
};
