<?php

namespace App\Helpers;

use App\Models\api\v1\Country;
use App\Models\api\v1\Gender;
use App\Models\api\v1\MemberShip;
use App\Models\api\v1\UserRole;
use App\Models\api\v1\UsersRolesSpace;

use App\Models\User;

class SerializerHelpers
{

    public static function serializeUser(User $user): array
    {
        return [
            "user" => [
                "id"                => $user->id,
                "uuid"              =>  $user->uuid,
                "username"          => $user->username,
                "email"             => $user->email,
                "email_verified_at" => DateHelpers::convertDateFromISOToRegular($user->email_verified_at),
                "created_at"        => DateHelpers::convertDateFromISOToRegular($user->created_at),
                "lastname"          => $user->lastname,
                "firstname"         => $user->firstname,
                "phone_code"        => $user->phone_code,
                "image"             => $user->image,
                "is_active"         => $user->is_active,
                "additional_infos"  => [
                    "roles"             => UserRole::GetRolesDetailsByUserId($user->id),
                    "gender"            => Gender::GetGenderDetailsById($user->gender_id),
                    "country"           => Country::getCountryDetailsById($user->country_id),
                    "userrolesspace"    => UsersRolesSpace::getUserRoleSpace($user->id),
                    "membership"       =>  MemberShip::getMemberShips($user->id),
                ]
            ]
        ];
    }
}
