<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class UsersRolesSpace extends Model
{
    use HasFactory;
    protected $guarded = ['id', 'created_at', 'updated_at'];


    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->uuid        = Str::uuid();
            $model->created_by  = auth()->user()->id ??  null;
            $model->is_active   = 1;
            $model->created_at  = now();
        });

    }
	
	public function space()
    {
        return $this->belongsTo(Space::class);
    }
 
    public static function getUserRoleSpace(int $user_id): array
    {
        $roles 		= Role::Where([['is_assignable', 1], ['is_deleted', 0]])->get()->pluck('id')->toArray();
        $user_roles = UserRole::whereIn('role_id',$roles)->Where([['user_id', $user_id], ['is_deleted', 0]])->get()->pluck('id')->toArray();
        $results 	= UsersRolesSpace::whereIn('user_role_id', $user_roles)->where('is_active',1)->with('space')->get()->toArray();
        
        return $results;
    }
}
