<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;
use App\Models\api\v1\Country;
use App\Models\api\v1\Stock;

/**
 * @property integer $id
 * @property uuid $uuid
 * @property int $country_id
 * @property string $code
 * @property string $name
 * @property string $address1
 * @property string $address2
 * @property float $lat
 * @property float $lng
 * @property string $neighborhood
 * @property string $municipality
 * @property string $city
 * @property integer $is_active
 * @property string $created_at
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_at
 * @property integer $is_deleted
 * @property string $deleted_at
 * @property integer $deleted_by
 * @property Country $country
 * @property Stock[] $stocks
 */
class Space extends Model
{
    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'integer';

    /**
     * @var array
     */
    protected $fillable = ['uuid','country_id', 'uuid', 'name', 'address1', 'address2', 'lat', 'lng', 'neighborhood', 'municipality', 'city', 'is_active', 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];
    protected $hidden = [ 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];

    /**
     * Scope Active
     */
    public function scopeActive($query) {
        return $query->where('spaces.is_active', '1');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function country()
    {
        return $this->belongsTo('App\Models\api\v1\Country');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function stocks()
    {
        return $this->hasMany('App\Models\api\v1\Stock');
    }
}
