<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserCode;
use Carbon\Carbon;
use Illuminate\Foundation\Auth\SendsPasswordResetEmails;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class ForgotPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset emails and
    | includes a trait which assists in sending these notifications from
    | your application to your users. Feel free to explore this trait.
    |
    */

    use SendsPasswordResetEmails;

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function showForgetPasswordForm(Request $request)
    {
        return view('auth.forgotPassword' , ['forgetpassword'=>true]);
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function submitForgetPasswordForm(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'phone' => 'required|numeric|starts_with:0|digits:10'
        ], [
            'phone.required' => 'Le champ Téléphone est obligatoire!',
            'phone.digits' => 'Le champ téléphone doit comporter 10 chiffres.',
            'phone.starts_with' => 'Le champ téléphone doit commencer par zero(0).'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator);
        }

        $phone = $request->phone;

        $loginRequest = User::where('phone', '+225' . $phone)->first();

        if ($loginRequest) {

            if (Auth::loginUsingId($loginRequest->id)) {
                auth()->user()->generateCode();
                return view('auth.reset2fa');
            }
        }

        return redirect("register")->withSuccess('Oppes! You have entered invalid credentials');
    }

    public function submitResetPasswordForm(Request $request)
    {
        $code = implode("", $request->code);

        $find = UserCode::where('user_id', auth()->user()->id)
            ->where('code', $code)
            ->where('updated_at', '>=', now()->subMinutes(2))
            ->first();

        if (!is_null($find)) {

            DB::table('users')
                ->where('id', auth()->user()->id)
                ->update([
                    'email_verified_at' => Carbon::today()->toDateTimeString(),
                ]);

            // Session::put('user_2fa', auth()->user()->id);
            
            return redirect()->route('reset.password.get');
        }

        return back()->with('error', 'Vous avez entré un mauvais code.');
    }
    
    public function showResetPasswordForm() {
        return view('auth.restPassword');
    }

    public function submitConfirmPasswordForm(Request $request) {
        $user = User::where('id', auth()->user()->id)->first();

        if (!is_null($user)) {

            DB::table('users')
                ->where('id', auth()->user()->id)
                ->update([
                    'email_verified_at' => Carbon::today()->toDateTimeString(),
                    'password' => Hash::make($request->password),
                ]);
            
            return redirect()->route('users.relogin');
        }
    }
}

