<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('qrcode', function (Blueprint $table) {
            $table->id();
            $table->string('num_carte', 255)->nullable();
            $table->string('titre', 255)->nullable();
            $table->string('sous_titre', 255)->nullable();
            $table->string('couleur', 255)->nullable();
            $table->string('status', 255)->nullable();
            $table->longText('qr_code')->nullable();
            $table->unsignedBigInteger('id_spaces')->unsigned()->nullable();
            $table->foreign('id_spaces')->references('id')->on('spaces');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('qrcode');
    }
};
