<?php

namespace Database\Seeders;

use Illuminate\Support\Str;
use App\Models\api\v1\Provider;
use App\Models\api\v1\ProviderByCountry;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ProvidersSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        if(Provider::count()== 0)
        {
            Provider::create([
                'code'          => Str::random(5),
                'name'          => "SOLIBRA",
                "created_by"    => 1
            ]);

            ProviderByCountry::create([
                "provider_id"   => 1,
                "country_id"    => 1,
                "created_by"    => 1
            ]);
            
            Provider::create([
                'code'          => Str::random(5),
                'name'          => "ATOU IVORIO",
                "created_by"    => 1
            ]);

            ProviderByCountry::create([
                "provider_id"   => 2,
                "country_id"    => 1,
                "created_by"    => 1
            ]);
        }
    }
}
