<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\api\v1\Device;
use Symfony\Component\HttpFoundation\Response;

class CheckDevice
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if($request->user() && $request->header('mobileId'))
        {
        
            $os = explode("-", $request->header('os'));
            $checkDevice = Device::where([
                'user_id'           => $request->user()->id,
                'device_token'      => $request->header('mobileId'),
                "os_version"        => $os[0] ?? ' ',
                "dare_miner"        => $os[1] ?? ' ',
                "is_active"         => 1,
                "is_deleted"        => 0,
            ])->first();

            if($checkDevice)
            {
                $checkDevice->update(['last_use'=> now()]);
            }else{
                Device::create([
                    'user_id'           => $request->user()->id,
                    'device_token'      => $request->header('mobileId'),
                    "os_version"        => $os[0] ?? '',
                    "dare_miner"        => $os[1] ?? '',
                    "is_active"         => 1,
                    'last_use'          => now(),
                    "is_deleted"        => 0,
                ]);
            }
        }
        return $next($request);
    }
}
