<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

/**
 * @property int $id
 * @property string $name
 * @property string $code
 * @property integer $is_active
 * @property string $created_at
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_at
 * @property integer $is_deleted
 * @property string $deleted_at
 * @property integer $deleted_by
 * @property CountriesPaymentMode[] $countriesPaymentModes
 * @property ProvidersByCountry[] $providersByCountries
 * @property Space[] $spaces
 * @property SubscriptionType[] $subscriptionTypes
 * @property User[] $users
 */
class Country extends Model
{
    /**
     * @var array
     */
    protected $fillable = ['name', 'uuid', 'is_active', 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];
    protected $hidden = ['created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];


    /**
     * Scope Active
     */
    public function scopeActive($query)
    {
        return $query->where('countries.is_active', '1');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function countriesPaymentModes()
    {
        return $this->hasMany('App\Models\api\v1\CountriesPaymentMode');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function providersByCountries()
    {
        return $this->hasMany('App\Models\api\v1\ProvidersByCountry');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function spaces()
    {
        return $this->hasMany('App\Models\api\v1\Space');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function subscriptionTypes()
    {
        return $this->hasMany('App\Models\api\v1\SubscriptionType');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users()
    {
        return $this->hasMany('App\Models\api\v1\User');
    }

    public static function whereIsNotDeleted(array $options): Builder
    {
        $full_options   = $options;
        $full_options[] = ["is_active", 1];
        $full_options[] = ["is_deleted", 0];

        return Country::where($full_options);
    }

    public static function getCountryDetailsById(int $country_id): array
    {
        $country = Country::whereIsNotDeleted(["id" => $country_id])->first();
        return [
            'id'        => $country->id,
            'name'      => $country->name,
            'uuid'      => $country->uuid,
            'is_active' => $country->is_active == 1
        ];
    }
}
