<?php

namespace App\Services;

class PaymentService {
    private $api_url;
    private $headers;

    public function __construct($api_url, $token = null) {
        $this->api_url = $api_url;
        $this->headers = array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$token,
            'X-API-KEY: '.env('FLEX_X_API_KEY'),
        );
    }

    public function sendRequest($method, $data = null) {
        $ch = curl_init($this->api_url);

        $options = array(
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => $this->headers,
            CURLOPT_CUSTOMREQUEST => $method,
        );

        if ($data !== null) {
            $options[CURLOPT_POSTFIELDS] = json_encode($data);
        }

        curl_setopt_array($ch, $options);

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new \Exception('Erreur Curl : ' . curl_error($ch));
        }

        curl_close($ch);

        return $response;
    }
}
