<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('providers_by_country', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedInteger('country_id')->index('country_id');
            $table->unsignedSmallInteger('provider_id')->index('provider_id');
            $table->unsignedSmallInteger('is_active')->nullable()->default(0);
            $table->timestamp('created_at')->useCurrent();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->dateTime('updated_at')->nullable();
            $table->unsignedSmallInteger('is_deleted')->nullable()->default(0);
            $table->dateTime('deleted_at')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('providers_by_country');
    }
};
