<?php

use App\Models\Partenaires;
use App\Services\OtpService;

use Illuminate\Http\Request;
use App\Helpers\NotificationHelpers;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\TwoFAController;
use App\Http\Controllers\api\v1\UriController;
use \App\Http\Controllers\api\v1\MFAController;
use \App\Http\Controllers\api\v1\RoleController;
use App\Http\Controllers\api\v1\CartesController;
use App\Http\Controllers\NotificationsController;
use App\Http\Controllers\api\v1\AccountController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/
// api ping
Route::get('/ping', function (Request $request)
{
    return "I am alive...";
});

Route::get('/send',function(){
    dump('ici');
    $return = NotificationHelpers::send(
        "[Hier 16:14] Marc Blei
        cyCgNEfso0akmgqkZsBi1T:APA91bFb3LecQ_fHCASpI9G7qxKJ2a7qfl49KPEWamA5DLdLZkQoNpTkJUc3BnIWWYNY01vyoyUZkDHudNgBAttnln8EFBNI8I0oamv3MmDa1jeWVDuPJoRKj2vsFlOgaAg5y-Y_8iCn",
        "Test notification ",
        "J'attends ton retour pour le test sur les notification" 
    );
});

//prefixage api key
Route::middleware(['with_fast_api_key','check_device'])->group(function ()
{
    //well-known-uri
//    Route::get('/well-known-uri', function (Request $request)
//    {
//        return response()->json(['success' => true, 'message' =>  '', 'data' => [
//                "LOGIN" => env('APP_URL').'/api/login-i0s11' , "REGISTRATION" => env('APP_URL').'/api/users/create' ]]);
//
//    });
     Route::get('/well-known-uri', [UriController::class, 'well_known_uri'])->name('WELL_KNOW_URI');

     // LOGIN
    route::post('/login', [UserController::class, 'login'])->name('LOGIN');

    // REGISTER USER
    route::post('/registration', [UserController::class, 'userCreate'])->name('REGISTRATION');
    route::post('/users/create', [UserController::class, 'userCreate'])->name('REGISTRATION');

    Route::prefix('roles')->group(function ()
    {
        route::get('/', [RoleController::class, 'list'])->name('ROLES_LIST'); //recuperer liste des role
    });

    // MFA
    Route::prefix('mfa')->group(function ()
    {
        route::post('/generate-send-code', [MFAController::class, 'generateSendCode'])->name('GENERATE_SEND_CODE');
        route::post('/verify-code', [MFAController::class, 'verifyCode'])->name('VERIFY_CODE');
    });

    // USERS
    Route::prefix('users')->middleware('auth:api')->group(function ()
    {
        route::post('/update/phone-number', [UserController::class, 'updatePhoneNumber'])->name('UPDATE_USER_PHONE_NUMBER');
        route::put('/update/profile', [UserController::class, 'userUpdateProfile'])->name('UPDATE_USER_PROFILE');
        route::put('/update/password', [UserController::class, 'updatePassword'])->name('UPDATE_USER_PASSWORD');
        route::put('/update/roles', [UserController::class, 'updateRoles'])->name('UPDATE_ROLES');
        route::get('/details', [UserController::class, 'details'])->name('USER_DETAILS');
        route::post('logout', [UserController::class, 'logout'])->name('USER_LOGOUT');
        route::delete('account', [UserController::class, 'deleteAccount'])->name('DELETE_USER_ACCOUNT');
    });	
});